/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMappingBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.JFedExperimenterGuiConfigResource;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resourcemapping")
@Produces(value={"application/json"})
public class ResourceMappingResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMappingResource.class);
    @Context
    UriInfo uriInfo;
    private final ResourceMappingDao resourceMappingDAO;
    private final FedmonWebApiServiceConfiguration configuration;
    private final JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource;

    public ResourceMappingResource(ResourceMappingDao resourceMappingDAO, FedmonWebApiServiceConfiguration configuration, JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource) {
        this.resourceMappingDAO = resourceMappingDAO;
        this.configuration = configuration;
        this.jFedExperimenterGuiConfigResource = jFedExperimenterGuiConfigResource;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<ResourceMapping> search(@Context HttpServletRequest request, @Nullable @QueryParam(value="serverId") Integer serverId, @Nullable @QueryParam(value="resourceId") Integer resourceId) {
        if (serverId != null && resourceId != null) {
            throw new BadRequestException("Search by serverId OR resourceId, but not both.");
        }
        if (serverId != null) {
            return this.resourceMappingDAO.findByServerId(serverId);
        }
        if (resourceId != null) {
            return this.resourceMappingDAO.findByResourceId(resourceId);
        }
        return this.resourceMappingDAO.findAll();
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public void insert(@NotNull ResourceMapping resourceMapping, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.resourceMappingDAO.insert(resourceMapping);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
    }

    @DELETE
    @Path(value="/{resourceId}/{resourceClassId}/{configSetId}")
    @Timed
    public void delete(@PathParam(value="resourceId") Integer resourceId, @PathParam(value="resourceClassId") String resourceClassId, @PathParam(value="configSetId") String configSetId, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        ResourceMappingBuilder resourceMappingBuilder = new ResourceMappingBuilder();
        resourceMappingBuilder.setResourceId(resourceId);
        resourceMappingBuilder.setResourceClassId(resourceClassId);
        resourceMappingBuilder.setConfigSetId(configSetId);
        ResourceMapping resourceMapping = resourceMappingBuilder.create();
        LOG.info("DELETE resource mapping: " + resourceMapping);
        this.resourceMappingDAO.delete(resourceMapping);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
    }
}

