/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import com.codahale.metrics.annotation.Timed;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rrd")
@Produces(value={"application/json"})
public class RrdResource {
    private static final Logger LOG = LoggerFactory.getLogger(RrdResource.class);
    @Context
    UriInfo uriInfo;
    private final FedmonWebApiServiceConfiguration configuration;
    private final TestInstanceDao testInstanceDao;
    private final SharedResourceCache sharedResourceCache;
    private final RrdManager rrdManager;

    public RrdResource(FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache, TestInstanceDao testInstanceDao) {
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
        this.testInstanceDao = testInstanceDao;
        this.rrdManager = new RrdManager((RrdConfig)configuration);
    }

    @GET
    @Timed
    public List<TestInstanceRrd.RawDataInfo> search(@Nullable @QueryParam(value="testinstanceid") Integer testInstanceId, @Nullable @QueryParam(value="testbedid") String testbedId, @Nullable @QueryParam(value="consolidationFunction") String consolidationFunction, @Nullable @QueryParam(value="periodDescription") String periodDescription, @Nullable @QueryParam(value="periodSeconds") Long periodSeconds, @Nullable @QueryParam(value="metric") String metric) throws SQLException {
        if (testInstanceId == null && testbedId == null) {
            throw new BadRequestException("Specify either \"testinstanceid\" or \"testbedid\" in the search string.");
        }
        if (testInstanceId != null && testbedId != null) {
            throw new BadRequestException("Specify either \"testinstanceid\" or \"testbedid\" in the search string, but not both.");
        }
        ArrayList<TestInstanceRrd.RawDataInfo> res = null;
        if (testInstanceId != null) {
            TestInstance testInstance = this.sharedResourceCache.getTestInstanceCache().getById(testInstanceId);
            res = this.getRawDataInfos(testInstance);
        }
        if (testbedId != null) {
            res = new ArrayList();
            List<TestInstance> testInstances = this.testInstanceDao.search(null, null, null, null, null, null, Arrays.asList(testbedId), null, false, null, null, null, null);
            for (TestInstance testInstance : testInstances) {
                if (!testInstance.isEnabled()) continue;
                res.addAll(this.getRawDataInfos(testInstance));
            }
        }
        if (res == null) {
            throw new WebApplicationException("bad request?", Response.Status.BAD_REQUEST);
        }
        res = res.stream().filter(rawDataInfo -> RrdResource.matchesRrdDetails(rawDataInfo, consolidationFunction, periodDescription, periodSeconds, metric)).collect(Collectors.toList());
        return res;
    }

    private static boolean matchesRrdDetails(TestInstanceRrd.RawDataInfo rawDataInfo, String consolidationFunction, String periodDescription, Long periodSeconds, String metric) {
        if (!(consolidationFunction == null || rawDataInfo.getConsolidationFunction() != null && rawDataInfo.getConsolidationFunction().equalsIgnoreCase(consolidationFunction))) {
            return false;
        }
        if (!(periodDescription == null || rawDataInfo.getPeriodDescription() != null && rawDataInfo.getPeriodDescription().replaceAll(" ", "").equalsIgnoreCase(periodDescription.replaceAll(" ", "")))) {
            return false;
        }
        if (!(metric == null || rawDataInfo.getMetrics() != null && rawDataInfo.getMetrics().contains(metric))) {
            return false;
        }
        return periodSeconds == null || Objects.equals(periodSeconds, rawDataInfo.getPeriodSeconds());
    }

    @Nonnull
    public List<TestInstanceRrd.RawDataInfo> getRawDataInfos(@Nonnull TestInstance testInstance) {
        TestDefinition testDefinition = this.sharedResourceCache.getTestDefinitionCache().getById(testInstance.getTestDefinitionId());
        if (testDefinition.getParameters().stream().noneMatch(p -> p.getName().equals("rrd_enabled"))) {
            return Collections.emptyList();
        }
        Frequency testInstanceFrequency = this.sharedResourceCache.getFrequencyCache().getById(testInstance.getFrequencyId());
        List testInstanceRrds = this.rrdManager.get(testInstance, testInstanceFrequency, testDefinition, false);
        LOG.debug("getRawDataInfo testInstance={} testInstanceRrds.size()={}", (Object)testInstance.getName(), (Object)testInstanceRrds.size());
        ArrayList<TestInstanceRrd.RawDataInfo> rawDataInfos = new ArrayList<TestInstanceRrd.RawDataInfo>();
        for (TestInstanceRrd rrd : testInstanceRrds) {
            rawDataInfos.addAll(rrd.getRawDataInfo(this.configuration.getBaseUrl()));
        }
        return rawDataInfos;
    }

    @Nonnull
    private TestInstanceRrd.RawDataInfo getRawDataInfos(@Nonnull String id) {
        int tiId;
        String[] idParts = id.trim().split("-");
        if (idParts.length != 3) {
            throw new NotFoundException("There is no RRD with ID " + id + " (and there can never be one, as this is a malformed ID (bad -))");
        }
        String periodDesc = idParts[1].trim();
        String consFunc = idParts[2].trim();
        LOG.debug("getRawDataInfo id=\"{}\" -> \"{}\" \"{}\" \"{}\"", new Object[]{id, idParts[0], periodDesc, consFunc});
        try {
            tiId = Integer.parseInt(idParts[0]);
        }
        catch (NumberFormatException e) {
            throw new NotFoundException("There is no RRD with ID " + id + " (and there can never be one, as this is a malformed ID (bad ti))");
        }
        TestInstance testInstance = this.sharedResourceCache.getTestInstanceCache().getById(tiId);
        List<TestInstanceRrd.RawDataInfo> rawDataInfos = this.getRawDataInfos(testInstance);
        LOG.debug("getRawDataInfo rawDataInfos.size()=" + rawDataInfos.size());
        for (TestInstanceRrd.RawDataInfo rawDataInfo : rawDataInfos) {
            LOG.debug("getRawDataInfo is checking {} {} <-> {} {}", new Object[]{rawDataInfo.getConsolidationFunction(), rawDataInfo.getPeriodDescription(), consFunc, periodDesc});
            if (!rawDataInfo.getConsolidationFunction().equals(consFunc) || !rawDataInfo.getPeriodDescription().replaceAll(" ", "").equals(periodDesc)) continue;
            return rawDataInfo;
        }
        throw new NotFoundException("There is no RRD with ID " + id);
    }

    @GET
    @Path(value="{id}")
    @Timed
    public TestInstanceRrd.RawDataInfo getRrdInfo(@NotNull @PathParam(value="id") String id) throws SQLException {
        TestInstanceRrd.RawDataInfo res = this.getRawDataInfos(id);
        return res;
    }

    @GET
    @Path(value="{id}/data")
    @Produces(value={"application/json"})
    @Timed
    public List<TestInstanceRrd.RawData> getRrdData(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) throws SQLException {
        TestInstanceRrd.RawDataInfo rawDataInfo = this.getRawDataInfos(id);
        return rawDataInfo.fetchRawData();
    }
}

