/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FrequencyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerGlimpseDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestDefinitionDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FrequencyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.TestbedResource;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.cache.CacheBuilder;
import jersey.repackaged.com.google.common.cache.CacheLoader;
import jersey.repackaged.com.google.common.cache.LoadingCache;
import jersey.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;

public class SharedResourceCache {
    private final FedmonWebApiServiceConfiguration configuration;
    private final TestInstanceDao testInstanceDao;
    private final TestDefinitionDao testDefinitionDao;
    private final ServerGlimpseDao serverGlimpseDao;
    private final FrequencyDao frequencyDao;
    private final FederationDao federationDao;
    private final SingleResourceCache<Integer, ServerGlimpse> serverGlimpseCache;
    private final SingleResourceCache<String, TestDefinition> testDefinitionCache;
    private final SingleResourceCache<Integer, TestInstance> testInstanceCache;
    private final SingleResourceCache<Integer, Frequency> frequencyCache;
    private final SingleResourceCache<String, Federation> federationCache;
    private final TestbedResource testbedResource;

    public SharedResourceCache(FedmonWebApiServiceConfiguration configuration, TestInstanceDao testInstanceDao, TestDefinitionDao testDefinitionDao, ServerGlimpseDao serverGlimpseDao, FrequencyDao frequencyDao, FederationDao federationDao, TestbedResource testbedResource) {
        this.configuration = configuration;
        this.testInstanceDao = testInstanceDao;
        this.testDefinitionDao = testDefinitionDao;
        this.serverGlimpseDao = serverGlimpseDao;
        this.frequencyDao = frequencyDao;
        this.federationDao = federationDao;
        this.testbedResource = testbedResource;
        testbedResource.setSharedResourceCache(this);
        this.serverGlimpseCache = new SingleResourceCache<Integer, ServerGlimpse>(id -> {
            ServerGlimpseBuilder resBuilder = serverGlimpseDao.getServerGlimpse((Integer)id);
            if (resBuilder == null) {
                throw new NotFoundException("There is no ServerGlimpse for serverId=" + id);
            }
            UriTool uriTool = configuration.getUriTool();
            uriTool.setUriRecursive((JsonLdObjectBuilder)resBuilder, true);
            ServerGlimpse res = resBuilder.create();
            return res;
        }, () -> {
            Collection<ServerGlimpseBuilder> resBuilders = serverGlimpseDao.findAllServerGlimpses();
            UriTool uriTool = configuration.getUriTool();
            ArrayList<ServerGlimpse> res = new ArrayList<ServerGlimpse>();
            for (ServerGlimpseBuilder builder : resBuilders) {
                uriTool.setUriRecursive((JsonLdObjectBuilder)builder, true);
                ServerGlimpse g = builder.create();
                res.add(g);
            }
            return res;
        }, ServerGlimpse::getServerId, 1L, TimeUnit.HOURS, 1L, TimeUnit.HOURS);
        this.testDefinitionCache = new SingleResourceCache<String, TestDefinition>(id -> {
            UriTool uriTool = configuration.getUriTool();
            TestDefinition res = testDefinitionDao.findById((String)id);
            if (res == null) {
                throw new NotFoundException("There is no object with id=" + id);
            }
            res = TestDefinitionBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (TestDefinition)res);
            res = (TestDefinition)uriTool.setUriRecursive((JsonLdObject)res);
            return res;
        }, () -> {
            UriTool uriTool = configuration.getUriTool();
            List<TestDefinition> resBase = testDefinitionDao.findAll();
            ArrayList<TestDefinition> res = new ArrayList<TestDefinition>(resBase.size());
            for (TestDefinition orig : resBase) {
                TestDefinition r = TestDefinitionBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (TestDefinition)orig);
                r = (TestDefinition)uriTool.setUriRecursive((JsonLdObject)r);
                res.add(r);
            }
            return res;
        }, PrimaryIdObject::getId, 1L, TimeUnit.HOURS, 1L, TimeUnit.HOURS);
        this.testInstanceCache = new SingleResourceCache<Integer, TestInstance>(id -> {
            UriTool uriTool = configuration.getUriTool();
            TestInstance res = testInstanceDao.findById((int)id);
            if (res == null) {
                throw new NotFoundException("There is no object with id=" + id);
            }
            res = TestInstanceBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (TestInstance)res);
            res = (TestInstance)uriTool.setUriRecursive((JsonLdObject)res);
            return res;
        }, () -> {
            UriTool uriTool = configuration.getUriTool();
            List<TestInstance> resBase = testInstanceDao.findAll();
            ArrayList<TestInstance> res = new ArrayList<TestInstance>(resBase.size());
            for (TestInstance orig : resBase) {
                TestInstance r = TestInstanceBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (TestInstance)orig);
                r = (TestInstance)uriTool.setUriRecursive((JsonLdObject)r);
                res.add(r);
            }
            return res;
        }, PrimaryIdObject::getId, 1L, TimeUnit.HOURS, 1L, TimeUnit.HOURS);
        this.frequencyCache = new SingleResourceCache<Integer, Frequency>(id -> {
            UriTool uriTool = configuration.getUriTool();
            Frequency res = frequencyDao.findById((Integer)id);
            if (res == null) {
                throw new NotFoundException("There is no object with id=" + id);
            }
            res = FrequencyBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (Frequency)res);
            res = (Frequency)uriTool.setUriRecursive((JsonLdObject)res);
            return res;
        }, () -> {
            UriTool uriTool = configuration.getUriTool();
            List<Frequency> resBase = frequencyDao.findAll();
            ArrayList<Frequency> res = new ArrayList<Frequency>(resBase.size());
            for (Frequency orig : resBase) {
                Frequency r = FrequencyBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (Frequency)orig);
                r = (Frequency)uriTool.setUriRecursive((JsonLdObject)r);
                res.add(r);
            }
            return res;
        }, PrimaryIdObject::getId, 1L, TimeUnit.HOURS, 1L, TimeUnit.HOURS);
        this.federationCache = new SingleResourceCache<String, Federation>(id -> {
            UriTool uriTool = configuration.getUriTool();
            Federation res = federationDao.findById((String)id).create();
            if (res == null) {
                throw new NotFoundException("There is no object with id=" + id);
            }
            res = FederationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (Federation)res);
            res = (Federation)uriTool.setUriRecursive((JsonLdObject)res);
            return res;
        }, () -> {
            UriTool uriTool = configuration.getUriTool();
            List<FederationBuilder> resBase = federationDao.findAll();
            ArrayList<Federation> res = new ArrayList<Federation>(resBase.size());
            for (FederationBuilder orig : resBase) {
                Federation r = FederationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (FederationBuilder)orig);
                r = (Federation)uriTool.setUriRecursive((JsonLdObject)r);
                res.add(r);
            }
            return res;
        }, PrimaryIdObject::getId, 1L, TimeUnit.HOURS, 1L, TimeUnit.HOURS);
    }

    public SingleResourceCache<Integer, ServerGlimpse> getServerGlimpseCache() {
        return this.serverGlimpseCache;
    }

    public SingleResourceCache<String, Federation> getFederationCache() {
        return this.federationCache;
    }

    public SingleResourceCache<String, TestDefinition> getTestDefinitionCache() {
        return this.testDefinitionCache;
    }

    public SingleResourceCache<Integer, TestInstance> getTestInstanceCache() {
        return this.testInstanceCache;
    }

    public SingleResourceCache<Integer, Frequency> getFrequencyCache() {
        return this.frequencyCache;
    }

    public void invalidateFull() {
        this.serverGlimpseCache.invalidateFull();
        this.testDefinitionCache.invalidateFull();
        this.testInstanceCache.invalidateFull();
        this.frequencyCache.invalidateFull();
        this.federationCache.invalidateFull();
        this.testbedResource.invalidateSearchCache();
    }

    public static class SingleResourceCache<IdType, ResourceType extends JsonLdObject> {
        private final LoadingCache<IdType, ResourceType> cache;
        private final SingleResourceGetter<IdType, ResourceType> singleGetter;
        private final AllResourceGetter<ResourceType> allGetter;
        private final CacheIdRetriever<IdType, ResourceType> idRetriever;
        private final long allCacheDuration;
        private final TimeUnit allCacheTimeUnit;
        private boolean cachedAll = false;
        private Date cachedAllExpireDate = null;

        public SingleResourceCache(final SingleResourceGetter<IdType, ResourceType> singleGetter, AllResourceGetter<ResourceType> allGetter, CacheIdRetriever<IdType, ResourceType> idRetriever, long singleCacheDuration, TimeUnit singleCacheTimeUnit, long allCacheDuration, TimeUnit allCacheTimeUnit) {
            this.singleGetter = singleGetter;
            this.allGetter = allGetter;
            this.idRetriever = idRetriever;
            this.allCacheDuration = allCacheDuration;
            this.allCacheTimeUnit = allCacheTimeUnit;
            this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(singleCacheDuration, singleCacheTimeUnit).build(new CacheLoader<IdType, ResourceType>(){

                public ResourceType load(IdType id) throws NotFoundException {
                    JsonLdObject res = (JsonLdObject)singleGetter.uncachedGetById(id);
                    return res;
                }
            });
        }

        @Nonnull
        public synchronized ResourceType getById(IdType id) throws NotFoundException, WebApplicationException {
            JsonLdObject res;
            try {
                res = (JsonLdObject)this.cache.get(id);
            }
            catch (com.google.common.util.concurrent.UncheckedExecutionException | ExecutionException | UncheckedExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof NotFoundException) {
                    throw new NotFoundException("There is no object with id=" + id);
                }
                if (e.getCause() != null && e.getCause() instanceof WebApplicationException) {
                    throw (WebApplicationException)e.getCause();
                }
                throw new WebApplicationException("Internal error", e, Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (res == null) {
                throw new NotFoundException("There is no object with id=" + id);
            }
            return (ResourceType)res;
        }

        @Nonnull
        public synchronized List<ResourceType> getAll() throws WebApplicationException {
            if (this.cachedAllExpireDate == null || this.cachedAllExpireDate.before(new Date())) {
                this.cachedAll = false;
            }
            if (this.cachedAll) {
                return new ArrayList(this.cache.asMap().values());
            }
            List<ResourceType> res = this.allGetter.uncachedGetAll();
            for (JsonLdObject r : res) {
                IdType id = this.idRetriever.getId(r);
                assert (id != null);
                if (id == null) continue;
                this.cache.put(id, (Object)r);
            }
            this.cachedAll = true;
            this.cachedAllExpireDate = new Date(System.currentTimeMillis() + this.allCacheTimeUnit.toMillis(this.allCacheDuration));
            return res;
        }

        public synchronized void invalidateGetAll() {
            this.cachedAll = false;
        }

        public synchronized void invalidateFull() {
            this.cachedAll = false;
            this.cache.invalidateAll();
        }

        public synchronized void invalidateAllAndSingle(IdType id) {
            this.cachedAll = false;
            this.cache.invalidate(id);
        }

        public synchronized void invalidateOnlySingle(IdType id) {
            this.cache.invalidate(id);
        }

        public synchronized void update(ResourceType newResource) {
            this.cache.put(this.idRetriever.getId(newResource), newResource);
        }

        public static interface SingleResourceGetter<IdType, ResourceType> {
            public ResourceType uncachedGetById(IdType var1) throws WebApplicationException;
        }

        public static interface AllResourceGetter<ResourceType> {
            public List<ResourceType> uncachedGetAll() throws WebApplicationException;
        }

        public static interface CacheIdRetriever<IdType, ResourceType> {
            @Nullable
            public IdType getId(ResourceType var1);
        }
    }
}

