/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.AdminDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/task")
@Produces(value={"application/json"})
public class TaskResource {
    @Context
    UriInfo uriInfo;
    private final TaskDao taskDao;
    private final AdminDao adminDao;
    private final TestInstanceDao testinstanceDAO;
    private final FedmonWebApiServiceConfiguration configuration;
    private static int MAX_REQUESTED_TASKS = 100;

    public TaskResource(TaskDao taskDao, AdminDao adminDao, TestInstanceDao testinstanceDAO, FedmonWebApiServiceConfiguration configuration) {
        this.taskDao = taskDao;
        this.adminDao = adminDao;
        this.testinstanceDAO = testinstanceDAO;
        this.configuration = configuration;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Task update(@NotNull @PathParam(value="id") Long id, Task task, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        if (!id.equals(task.getId())) {
            throw new WebApplicationException("path ID does not match provided JSON id", Response.Status.BAD_REQUEST);
        }
        TaskBuilder taskBuilder = new TaskBuilder(task);
        if (task.getDeadline() == null) {
            throw new WebApplicationException("Task must always have deadline", Response.Status.BAD_REQUEST);
        }
        switch (task.getState()) {
            case CREATED: 
            case CANCELLING: 
            case RUNNING: {
                if (task.getStop() != null) {
                    throw new WebApplicationException("Task in state " + task.getState() + " cannot have a stop time set", Response.Status.BAD_REQUEST);
                }
                if (task.getResultId() == null) break;
                throw new WebApplicationException("Task in state " + task.getState() + " cannot have a result", Response.Status.BAD_REQUEST);
            }
            case CANCELLED: {
                if (task.getStop() == null) {
                    taskBuilder.setStop(Clock.nowDate());
                }
                if (task.getResultId() == null) break;
                throw new WebApplicationException("Task set to state " + task.getState() + " cannot have a result set", Response.Status.BAD_REQUEST);
            }
            case FINISHED: {
                throw new WebApplicationException("Cannot change Task to FINISHED, or change FINISHED Task", Response.Status.BAD_REQUEST);
            }
            case EXPIRED: {
                throw new WebApplicationException("Cannot change Task to EXPIRED, or change EXPIRED Task", Response.Status.BAD_REQUEST);
            }
            default: {
                throw new WebApplicationException("Server implementation bug: Unhandled state: " + task.getState(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        this.taskDao.updateAll(task, Clock.nowTimestamp());
        return this.addUris(this.uriInfo, taskBuilder).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @GET
    @Timed
    public List<Task> getAll(@QueryParam(value="active") Boolean active, @QueryParam(value="expired") Boolean expired, @QueryParam(value="last") Integer last) {
        List<Task> baseRes;
        if (active != null && expired != null) {
            throw new WebApplicationException("The 'active' and 'expired' parameters are mutually exclusive", Response.Status.BAD_REQUEST);
        }
        if (last != null && last > MAX_REQUESTED_TASKS) {
            throw new WebApplicationException("Maximum " + MAX_REQUESTED_TASKS + " last tasks can be requested. You requested " + last + ".", Response.Status.BAD_REQUEST);
        }
        if (last == null) {
            last = MAX_REQUESTED_TASKS;
        }
        if (expired != null) {
            if (!expired.booleanValue()) {
                throw new WebApplicationException("The 'expired' parameters must either be missing, or set to 'true'", Response.Status.BAD_REQUEST);
            }
            baseRes = this.taskDao.findExpired(last, Clock.nowTimestamp());
        } else {
            baseRes = active == null ? this.taskDao.findAll(last) : (active != false ? this.taskDao.findActive(last, Clock.nowTimestamp()) : this.taskDao.findHistoric(last, Clock.nowTimestamp()));
        }
        ArrayList<Task> res = new ArrayList<Task>(baseRes.size());
        for (Task task : baseRes) {
            TaskBuilder taskBuilder = new TaskBuilder(task);
            this.addUris(this.uriInfo, taskBuilder);
            res.add(taskBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
        }
        return res;
    }

    @POST
    @Timed
    public List<Task> findAndCreate(@QueryParam(value="maxCount") Integer maxCount, @NotNull @QueryParam(value="runInfo") String runInfo, @QueryParam(value="testinstanceid") Integer testInstanceId, @QueryParam(value="testversionname") String testVersionName, @QueryParam(value="testdefinitionname") String testDefinitionName, @QueryParam(value="testbed") String testbed, @QueryParam(value="testname") String testInstanceName, @QueryParam(value="stresstestCount") Integer stressTestCount, @Context HttpServletRequest request) {
        ArrayList<Object> res;
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        Timestamp start = Clock.nowTimestamp();
        if (stressTestCount == null || stressTestCount <= 0) {
            if (maxCount == null) {
                throw new BadRequestException("maxCount is required");
            }
            List<String> testDefinitionNameArray = testDefinitionName == null ? null : Arrays.asList(testDefinitionName.split(","));
            boolean requestedProdTests = testVersionName != null && testVersionName.startsWith("prod");
            Admin currentAdmin = this.adminDao.get();
            if (currentAdmin.getDisableAllTests().booleanValue() || currentAdmin.getDisableProductionTests().booleanValue() && requestedProdTests) {
                return Collections.emptyList();
            }
            Timestamp deadline = new Timestamp(start.getTime() + Task.CREATED_TASK_DEADLINE_MILLIS);
            List<Task> resBase = this.taskDao.searchAndCreate(maxCount, testInstanceId, testVersionName, testDefinitionNameArray, testbed, testInstanceName, runInfo, start, deadline, Clock.nowTimestamp());
            currentAdmin = this.adminDao.get();
            if (currentAdmin.getDisableAllTests().booleanValue() || currentAdmin.getDisableProductionTests().booleanValue() && requestedProdTests) {
                if (currentAdmin.getDisableAllTests().booleanValue()) {
                    this.taskDao.forceCancelStateAll(new Timestamp(System.currentTimeMillis()));
                }
                return Collections.emptyList();
            }
            res = new ArrayList(resBase.size());
            for (Task task : resBase) {
                TaskBuilder taskBuilder = new TaskBuilder(task);
                this.addUris(this.uriInfo, taskBuilder);
                res.add(taskBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
            }
        } else {
            if (testInstanceId == null) {
                throw new BadRequestException("stresstestCount requires testinstanceid");
            }
            if (maxCount != null || testVersionName != null || testDefinitionName != null || testbed != null || testInstanceName != null) {
                throw new BadRequestException("maxCount, testversionname, testdefinitionname, testbed and testname are not allowed with stresstestcount");
            }
            Admin currentAdmin = this.adminDao.get();
            if (currentAdmin.getDisableAllTests().booleanValue()) {
                return Collections.emptyList();
            }
            Timestamp deadline = new Timestamp(start.getTime() + Task.STRESSTEST_CREATED_TASK_DEADLINE_MILLIS);
            List<Task> resBase = this.taskDao.createMultiple(stressTestCount, testInstanceId, runInfo, start, deadline, Clock.nowTimestamp());
            res = new ArrayList<Task>(resBase.size());
            for (Task task : resBase) {
                TaskBuilder taskBuilder = new TaskBuilder(task);
                this.addUris(this.uriInfo, taskBuilder);
                res.add(taskBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
            }
        }
        return res;
    }

    @POST
    @Path(value="expired")
    @Timed
    public List<Task> handleExpired(@Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        List<Task> resBase = this.taskDao.handleExpired(Clock.nowTimestamp());
        ArrayList<Task> res = new ArrayList<Task>(resBase.size());
        for (Task task : resBase) {
            TaskBuilder taskBuilder = new TaskBuilder(task);
            this.addUris(this.uriInfo, taskBuilder);
            res.add(taskBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Task get(@NotNull @PathParam(value="id") Long id) {
        Task resBase = this.taskDao.findById(id);
        if (resBase == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        return this.addUris(this.uriInfo, resBase).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Long id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        this.taskDao.deleteById(id);
    }

    public TaskBuilder addUris(UriInfo uriInfo, Task orig) {
        assert (orig != null);
        assert (orig.getId() != null);
        TaskBuilder res = new TaskBuilder(orig);
        res.useImplicitState();
        res = (TaskBuilder)this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)res);
        return res;
    }

    public TaskBuilder addUris(UriInfo uriInfo, TaskBuilder orig) {
        assert (orig != null);
        assert (orig.getId() != null);
        orig.useImplicitState();
        return (TaskBuilder)this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)orig);
    }
}

