/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserConfigSetMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserConfigSetMapping;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/userconfigsetmapping")
@Produces(value={"application/json"})
public class UserConfigSetMappingResource {
    private static final Logger LOG = LoggerFactory.getLogger(UserConfigSetMappingResource.class);
    @Context
    UriInfo uriInfo;
    private final UserConfigSetMappingDao userConfigSetMappingDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public UserConfigSetMappingResource(UserConfigSetMappingDao userConfigSetMappingDAO, FedmonWebApiServiceConfiguration configuration) {
        this.userConfigSetMappingDAO = userConfigSetMappingDAO;
        this.configuration = configuration;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<UserConfigSetMapping> all() {
        List<UserConfigSetMapping> res = this.userConfigSetMappingDAO.findAll();
        return res;
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public void insert(@NotNull UserConfigSetMapping userConfigSetMapping, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.userConfigSetMappingDAO.insert(userConfigSetMapping);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Timed
    public void delete(@NotNull UserConfigSetMapping userConfigSetMapping, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        LOG.info("DELETE resource mapping: " + userConfigSetMapping);
        int deleted = this.userConfigSetMappingDAO.delete(userConfigSetMapping);
    }
}

