/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterColumnMapper {
    public Class<? extends ResultColumnMapper<?>>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            RegisterColumnMapper ma = (RegisterColumnMapper)annotation;
            final ResultColumnMapper[] m = new ResultColumnMapper[ma.value().length];
            try {
                Class<? extends ResultColumnMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result column mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultColumnMapper mapper : m) {
                            q.registerColumnMapper(mapper);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterColumnMapper ma = (RegisterColumnMapper)annotation;
            final ResultColumnMapper[] m = new ResultColumnMapper[ma.value().length];
            try {
                Class<? extends ResultColumnMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result column mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultColumnMapper mapper : m) {
                            q.registerColumnMapper(mapper);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined for parameter");
        }
    }
}

