/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum URIColumnMapper implements ResultColumnMapper<URI>
{
    INSTANCE;


    @Override
    public URI mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        return URIColumnMapper.uriFromString(r.getString(columnNumber));
    }

    @Override
    public URI mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        return URIColumnMapper.uriFromString(r.getString(columnLabel));
    }

    public static URI uriFromString(String s) throws SQLException {
        try {
            return s != null ? new URI(s) : null;
        }
        catch (URISyntaxException e) {
            throw new SQLException("Failed to convert data to URI", e);
        }
    }
}

