/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model.test;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.ErrorDetails;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.bugreport.model.SliceBuilder;
import be.iminds.ilabt.jfed.bugreport.model.Sliver;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobStateReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.TaskExecutionReport;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class BugReportTestCollection
extends ObjectWithIdTestCollection<Integer, BugReport, BugReportBuilder> {
    private final Clock clock;

    public BugReportTestCollection() {
        this(Clock.fixed(Instant.ofEpochSecond(1264896000L), ZoneId.of("UTC")));
    }

    public BugReportTestCollection(Clock clock) {
        super(Integer.class, BugReport.class, BugReportBuilder.class);
        this.clock = clock;
        BugReportBuilder bugReport1 = ((BugReportBuilder)new BugReportBuilder().setId((Object)0)).setReportTarget(BugReport.ReportTarget.JFED).setReportType(BugReport.ReportType.BUG).setPostOnPublicList(Boolean.valueOf(true)).setRelatedTestbeds(Arrays.asList(GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"auth", (String)"am"), GeniUrn.createGeniUrnFromEncodedParts((String)"two.example.com", (String)"auth", (String)"am"))).addConnectivityTestResults(new ConnectivityTestResult("conTest1", ConnectivityTestResult.Status.SUCCEEDED, "conTestMessage1", null)).addConnectivityTestResults(new ConnectivityTestResult("conTest2", ConnectivityTestResult.Status.FAILED, "conTestMessage2", "conTest stacktrace")).addLogLine(new LogLine(clock.instant().minus(5L, ChronoUnit.MINUTES), "class1", "DEBUG", "message1", null, "thread 1")).addLogLine(new LogLine(clock.instant().minus(7L, ChronoUnit.MINUTES), "class2", "ERROR", "message2", "stacktrace", "thread 2")).addSlice(new SliceBuilder().setExpirationDate(clock.instant().plus(30L, ChronoUnit.MINUTES)).setStatus("ACTIVE").setSliceUrn(GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"slice", (String)"s1").getValue()).addSliver(new Sliver(GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"slivre", (String)"s1-1").getValue(), "CURACTIVE", "ACTIVESLIVER", clock.instant().plus(29L, ChronoUnit.MINUTES), Boolean.valueOf(true), Arrays.asList("comp1", "comp2"), Arrays.asList(new ErrorDetails("sliverError1", GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"slivre", (String)"s1-1a"), GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"slivre", (String)"s1-1-c"), clock.instant().minus(1L, ChronoUnit.MINUTES))))).create()).addStitchingJobReport(new StitchingJobReportBuilder().setName("stitch report 1").addStitchingJobStateReport(new StitchingJobStateReportBuilder().setStart(clock.instant().minus(31L, ChronoUnit.MINUTES)).setEnd(clock.instant().minus(21L, ChronoUnit.MINUTES)).setName("stitch report 1 state 1").setStatus("SUCCEEDED").addTaskExecution(new TaskExecutionReport("TaskExecutionReport1", "TaskExecutionReport 1", "SUCCESS", "taskClass1", clock.instant().minus(14L, ChronoUnit.MINUTES), clock.instant().minus(16L, ChronoUnit.MINUTES), Arrays.asList(1, 2, 3), null)).addLogEntry(new LogLine(clock.instant().minus(15L, ChronoUnit.MINUTES), "classX", "TRACE", "messageX", null, "thread X")).create()).create()).setDescription("Description 1").setEnvironment("Environment 1").setLoggedInUserInfo("LoggedInUserInfo 1").setPreferences("test = one\npref = p\n").setReporterUrn(GeniUrn.createGeniUrnFromEncodedParts((String)"example.com", (String)"user", (String)"one").getValue()).setSubject("Test Subject 1").setVersion("version1").setMail("tester@example.com").setCommitTime(clock.instant()).setScreenshot("screenshot 1");
        this.all.add(bugReport1);
        BugReportBuilder bugReport2 = ((BugReportBuilder)new BugReportBuilder().setId((Object)1)).setReportTarget(BugReport.ReportTarget.OTHER).setReportType(BugReport.ReportType.OTHER).setPostOnPublicList(Boolean.valueOf(false)).setRelatedTestbeds(Arrays.asList(GeniUrn.createGeniUrnFromEncodedParts((String)"three.example.com", (String)"auth", (String)"am"))).addConnectivityTestResults(new ConnectivityTestResult("conTest3", ConnectivityTestResult.Status.WARNING, "conTestMessage3", null)).addLogLine(new LogLine(clock.instant().minus(51L, ChronoUnit.MINUTES), "class3", "INFO", "message3", null, "thread 3")).setDescription("Description 2").setEnvironment("Environment 2").setLoggedInUserInfo("LoggedInUserInfo 2").setPreferences("test = two\npref = p2\n").setReporterUrn(GeniUrn.createGeniUrnFromEncodedParts((String)"three.example.com", (String)"user", (String)"three").getValue()).setSubject("Test Subject 2").setVersion("version2").setMail("tester2@example.com").setCommitTime(clock.instant().plus(10L, ChronoUnit.SECONDS)).setScreenshot("screenshot 2");
        this.all.add(bugReport2);
        BugReportBuilder bugReport3 = ((BugReportBuilder)new BugReportBuilder().setId((Object)2)).setCommitTime(clock.instant().plus(20L, ChronoUnit.SECONDS));
        this.all.add(bugReport3);
    }

    public Clock getClock() {
        return this.clock;
    }

    public void assertSameExtraIds(BugReport actual, BugReport expected) {
    }

    public void assertSameDetails(BugReport actual, BugReport expected) {
        MatcherAssert.assertThat((Object)actual.getCommitTime(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getCommitTime())));
        MatcherAssert.assertThat((Object)actual.getConnectivityTestResults(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getConnectivityTestResults())));
        MatcherAssert.assertThat((Object)actual.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDescription())));
        MatcherAssert.assertThat((Object)actual.getEnvironment(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getEnvironment())));
        MatcherAssert.assertThat((Object)actual.getLoggedInUserInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLoggedInUserInfo())));
        MatcherAssert.assertThat((Object)actual.getLogLines(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLogLines())));
        MatcherAssert.assertThat((Object)actual.getMail(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getMail())));
        MatcherAssert.assertThat((Object)actual.getPostOnPublicList(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPostOnPublicList())));
        MatcherAssert.assertThat((Object)actual.getPreferences(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPreferences())));
        MatcherAssert.assertThat((Object)actual.getRelatedTestbeds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getRelatedTestbeds())));
        MatcherAssert.assertThat((Object)actual.getReporterUrn(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getReporterUrn())));
        MatcherAssert.assertThat((Object)actual.getReportTarget(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getReportTarget())));
        MatcherAssert.assertThat((Object)actual.getReportType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getReportType())));
        MatcherAssert.assertThat((Object)actual.getScreenshot(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getScreenshot())));
        MatcherAssert.assertThat((Object)actual.getSlices(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSlices())));
        MatcherAssert.assertThat((Object)actual.getStitchingJobReports(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getStitchingJobReports())));
        MatcherAssert.assertThat((Object)actual.getSubject(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSubject())));
        MatcherAssert.assertThat((Object)actual.getVersion(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getVersion())));
    }

    public void assertSearchLinks(BugReport actual) {
    }
}

