/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.dao.BugReportCallDao;
import be.iminds.ilabt.jfed.bugreport.dao.BugReportCallMapper;
import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.test.BugReportTestCollection;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiApplication;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.test.BugReportCallTestCollection;
import be.iminds.ilabt.jfed.bugreport.test.JFedBugReportTestPostgresDB;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class BugReportCallDaoTest {
    @ClassRule
    public static final DropwizardAppRule<JFedBugReportWebApiConfiguration> RULE = new DropwizardAppRule(JFedBugReportWebApiApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static JFedBugReportTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static BugReportCallDao bugReportCallDao;
    private BugReportTestCollection bugReportTestCollection;
    private BugReportCallTestCollection bugReportCallTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        testPostgresDB = new JFedBugReportTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        JFedBugReportWebApiConfiguration configuration = (JFedBugReportWebApiConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        bugReportCallDao = (BugReportCallDao)jdbi.onDemand(BugReportCallDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)bugReportCallDao);
        jdbi = null;
        bugReportCallDao = null;
        testPostgresDB = null;
        System.gc();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.bugReportTestCollection = new BugReportTestCollection();
        this.bugReportCallTestCollection = new BugReportCallTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
    }

    @Test
    public void testFindById1() throws Exception {
        int index = 0;
        SerializableApiCallDetails expectedBugReportCall = this.bugReportCallTestCollection.getByIndex(index);
        int bugReportId = (Integer)((BugReport)this.bugReportTestCollection.getByIndex(0)).getId();
        Integer callId = expectedBugReportCall.getId();
        SerializableApiCallDetails actualBugReportCall = bugReportCallDao.get(bugReportId, callId.intValue());
        MatcherAssert.assertThat((String)("Did not find serializableApiCallDetails " + bugReportId + " " + callId), (Object)actualBugReportCall, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportCallTestCollection.assertSame(actualBugReportCall, expectedBugReportCall);
    }

    @Test
    public void testFindById2() throws Exception {
        int index = 1;
        SerializableApiCallDetails expectedBugReportCall = this.bugReportCallTestCollection.getByIndex(index);
        int bugReportId = (Integer)((BugReport)this.bugReportTestCollection.getByIndex(0)).getId();
        Integer callId = expectedBugReportCall.getId();
        SerializableApiCallDetails actualBugReportCall = bugReportCallDao.get(bugReportId, callId.intValue());
        MatcherAssert.assertThat((String)("Did not find serializableApiCallDetails " + bugReportId + " " + callId), (Object)actualBugReportCall, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportCallTestCollection.assertSame(actualBugReportCall, expectedBugReportCall);
    }

    @Test
    public void testFindById3() throws Exception {
        int index = 2;
        SerializableApiCallDetails expectedBugReportCall = this.bugReportCallTestCollection.getByIndex(index);
        int bugReportId = (Integer)((BugReport)this.bugReportTestCollection.getByIndex(0)).getId();
        Integer callId = expectedBugReportCall.getId();
        SerializableApiCallDetails actualBugReportCall = bugReportCallDao.get(bugReportId, callId.intValue());
        MatcherAssert.assertThat((String)("Did not find serializableApiCallDetails " + bugReportId + " " + callId), (Object)actualBugReportCall, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportCallTestCollection.assertSame(actualBugReportCall, expectedBugReportCall);
    }

    @Test
    public void testInsert() throws Exception {
        Clock clock = this.bugReportCallTestCollection.getClock();
        SerializableApiCallDetails newBugReportCall = new SerializableApiCallDetails(9, "authorityName3", "authorityUrn3", "baseServerUrl3", "callServerUrl3", (JFedConnection.ProxyInfo)new JFedConnection.SshProxyInfo("hostname3", 8022, Proxy.limitUsername((String)"usrname3"), null, "hostKey3"), "connectionSslAuthUserUrn3", "connectionBasicHttpAuthUsername3", "connectionId3", "connectionSslAuthUserCertificates3", "connectionAuthenticationMethod3", "connectionProtocol3", "connectionType3", "httpRequestStatusLine3", "httpRequestHeaders3", "httpRequest3", "httpResponseStatusLine3", "httpResponseHeaders3", "httpResponse3", "apiName3", "javaMethodName3", "geniMethodName3", "xmlRpcRequestJsonString3", "xmlRpcResponseJsonString3", "xmlRpcGeniResponseValue3", "xmlRpcGeniResponseOutput3", "xmlRpcGeniResponseCode3", Integer.valueOf(3), "geniResponseCodeDescription3", Boolean.valueOf(false), "geniResponseOutput3", Date.from(clock.instant().minus(79L, ChronoUnit.MINUTES)), Date.from(clock.instant().minus(78L, ChronoUnit.MINUTES)), "protogeniSpewLogUrl3", "exceptionString3");
        int bugReportId = (Integer)((BugReport)this.bugReportTestCollection.getByIndex(0)).getId();
        int callId = newBugReportCall.getId();
        int rowsInserted = bugReportCallDao.insert(bugReportId, callId, newBugReportCall);
        MatcherAssert.assertThat((Object)rowsInserted, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        SerializableApiCallDetails expectedNewBugReportCall = newBugReportCall;
        SerializableApiCallDetails actualNewBugReportCall = bugReportCallDao.get(bugReportId, callId);
        System.out.println("Lookup inserted serializableApiCallDetails (" + bugReportId + " " + callId + ") result: " + actualNewBugReportCall);
        MatcherAssert.assertThat((Object)actualNewBugReportCall, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualNewBugReportCall.getId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)callId)));
        this.bugReportCallTestCollection.assertSame(expectedNewBugReportCall, actualNewBugReportCall);
    }

    @Test
    public void testRemoveQuotesA() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"\"blah\""), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"blah")));
    }

    @Test
    public void testRemoveQuotesB() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"\"\""), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"")));
    }

    @Test
    public void testRemoveQuotesC() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"blih"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"blih")));
    }

    @Test
    public void testRemoveQuotesD() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"\"bloh"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"\"bloh")));
    }

    @Test
    public void testRemoveQuotesE() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"bluh\""), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bluh\"")));
    }

    @Test
    public void testRemoveQuotesF() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes((String)"\"\"double\"\""), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"\"double\"")));
    }

    @Test
    public void testRemoveQuotesG() {
        MatcherAssert.assertThat((Object)BugReportCallMapper.removeQuotes(null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

