/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessToken;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessTokenBuilder;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class OAuthAccessTokenTestCollection
extends BasicObjectTestCollection<OAuthAccessToken, OAuthAccessTokenBuilder> {
    private final Clock clock;

    public OAuthAccessTokenTestCollection() {
        this(Clock.fixed(Instant.ofEpochSecond(1264896000L), ZoneId.of("UTC")));
    }

    public OAuthAccessTokenTestCollection(Clock clock) {
        super(OAuthAccessToken.class, OAuthAccessTokenBuilder.class);
        this.clock = clock;
        OAuthAccessTokenBuilder oAuthAccessToken1 = new OAuthAccessTokenBuilder();
        oAuthAccessToken1.setUsername("user1");
        oAuthAccessToken1.setServiceProviderBaseUrl("http://example.com/");
        oAuthAccessToken1.setAccessToken("FakeAccessToken1");
        this.all.add(oAuthAccessToken1);
        OAuthAccessTokenBuilder oAuthAccessToken2 = new OAuthAccessTokenBuilder();
        oAuthAccessToken2.setUsername("user2");
        oAuthAccessToken2.setServiceProviderBaseUrl("http://example.com/");
        oAuthAccessToken2.setAccessToken("FakeAccessToken2");
        this.all.add(oAuthAccessToken2);
        OAuthAccessTokenBuilder oAuthAccessToken3 = new OAuthAccessTokenBuilder();
        oAuthAccessToken3.setUsername("user1");
        oAuthAccessToken3.setServiceProviderBaseUrl("http://example.com/2/");
        oAuthAccessToken3.setAccessToken("FakeAccessToken3");
        this.all.add(oAuthAccessToken3);
    }

    public Clock getClock() {
        return this.clock;
    }

    public void assertSameDetails(OAuthAccessToken actual, OAuthAccessToken expected) {
        MatcherAssert.assertThat((Object)actual.getUsername(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getUsername())));
        MatcherAssert.assertThat((Object)actual.getServiceProviderBaseUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getServiceProviderBaseUrl())));
        MatcherAssert.assertThat((Object)actual.getAccessToken(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getAccessToken())));
    }

    public OAuthAccessToken getForInsert() {
        return new OAuthAccessTokenBuilder().setUsername("dummy5").setServiceProviderBaseUrl("http://example.com/5/").setAccessToken("dummytokenInsert").create();
    }
}

