/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessToken;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessTokenTestCollection;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthDao;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiApplication;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.test.JFedBugReportTestPostgresDB;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class OAuthDaoTest {
    @ClassRule
    public static final DropwizardAppRule<JFedBugReportWebApiConfiguration> RULE = new DropwizardAppRule(JFedBugReportWebApiApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static JFedBugReportTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static OAuthDao oAuthDao;
    private OAuthAccessTokenTestCollection oAuthAccessTokenTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        testPostgresDB = new JFedBugReportTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        JFedBugReportWebApiConfiguration configuration = (JFedBugReportWebApiConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        oAuthDao = (OAuthDao)jdbi.onDemand(OAuthDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)oAuthDao);
        jdbi = null;
        oAuthDao = null;
        testPostgresDB = null;
        System.gc();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.oAuthAccessTokenTestCollection = new OAuthAccessTokenTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
    }

    @Test
    public void testFind0() throws Exception {
        int index = 0;
        OAuthAccessToken expectedOAuthAccessToken = (OAuthAccessToken)this.oAuthAccessTokenTestCollection.getByIndex(index);
        OAuthAccessToken actualOAuthAccessToken = oAuthDao.get(expectedOAuthAccessToken.getUsername(), expectedOAuthAccessToken.getServiceProviderBaseUrl());
        MatcherAssert.assertThat((String)("Did not find oAuthAccessToken " + expectedOAuthAccessToken), (Object)actualOAuthAccessToken, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.oAuthAccessTokenTestCollection.assertSame((JsonLdObject)expectedOAuthAccessToken, (JsonLdObject)actualOAuthAccessToken, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
    }

    @Test
    public void testFind1() throws Exception {
        int index = 1;
        OAuthAccessToken expectedOAuthAccessToken = (OAuthAccessToken)this.oAuthAccessTokenTestCollection.getByIndex(index);
        OAuthAccessToken actualOAuthAccessToken = oAuthDao.get(expectedOAuthAccessToken.getUsername(), expectedOAuthAccessToken.getServiceProviderBaseUrl());
        MatcherAssert.assertThat((String)("Did not find oAuthAccessToken " + expectedOAuthAccessToken), (Object)actualOAuthAccessToken, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.oAuthAccessTokenTestCollection.assertSame((JsonLdObject)expectedOAuthAccessToken, (JsonLdObject)actualOAuthAccessToken, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
    }

    @Test
    public void testFind2() throws Exception {
        int index = 2;
        OAuthAccessToken expectedOAuthAccessToken = (OAuthAccessToken)this.oAuthAccessTokenTestCollection.getByIndex(index);
        OAuthAccessToken actualOAuthAccessToken = oAuthDao.get(expectedOAuthAccessToken.getUsername(), expectedOAuthAccessToken.getServiceProviderBaseUrl());
        MatcherAssert.assertThat((String)("Did not find oAuthAccessToken " + expectedOAuthAccessToken), (Object)actualOAuthAccessToken, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.oAuthAccessTokenTestCollection.assertSame((JsonLdObject)expectedOAuthAccessToken, (JsonLdObject)actualOAuthAccessToken, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
    }

    @Test
    public void testInsert() throws Exception {
        OAuthAccessToken expectedNewOAuthAccessToken = this.oAuthAccessTokenTestCollection.getForInsert();
        Integer rowsModified = oAuthDao.insert(expectedNewOAuthAccessToken);
        MatcherAssert.assertThat((Object)rowsModified, (Matcher)Matchers.is((Object)1));
        OAuthAccessToken actualNewOAuthAccessToken = oAuthDao.get(expectedNewOAuthAccessToken.getUsername(), expectedNewOAuthAccessToken.getServiceProviderBaseUrl());
        System.out.println("Lookup inserted oAuthAccessToken result: " + actualNewOAuthAccessToken);
        MatcherAssert.assertThat((Object)actualNewOAuthAccessToken, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.oAuthAccessTokenTestCollection.assertSame((JsonLdObject)expectedNewOAuthAccessToken, (JsonLdObject)actualNewOAuthAccessToken, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
    }
}

