/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JFedConnection {
    private static final Logger LOG = LoggerFactory.getLogger(JFedConnection.class);
    private static final int CONNECT_TIMEOUT = 5000;
    private static final long CON_EXPIRE_MS = 25000L;
    @Nonnull
    protected final ConnectionConfig connectionConfig;
    @Nonnull
    protected final String serverUrl;
    protected boolean error = false;
    @Nullable
    protected final DebugInfo debugInfo;
    private static final AtomicInteger nextConnectionId = new AtomicInteger();
    private final int connectionId = nextConnectionId.getAndIncrement();
    private Date lastCallTime;
    private long connectionExpireMs = 25000L;
    private int userCount = 0;
    @Nullable
    private JFedConnectionFactory connectionFactory;
    X509Certificate[] serverCertificates;

    public int getConnectionId() {
        return this.connectionId;
    }

    protected JFedConnection(@Nonnull ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        this.debugInfo = connectionConfig.getDebugInfo();
        if (connectionConfig.getServerUrlString() == null) {
            throw new IllegalArgumentException("Illegal argument: serverURL == null");
        }
        this.serverUrl = connectionConfig.getServerUrlString();
    }

    @Nullable
    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    @Nonnull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Nonnull
    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void markError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public ProxyInfo getProxyInfo() {
        return this.connectionConfig.getProxyInfo();
    }

    public abstract void close();

    public void markCallTime() {
        this.lastCallTime = new Date();
    }

    public Date getLastCallTime() {
        return this.lastCallTime;
    }

    public boolean isExpired() {
        if (this.isInUse()) {
            return false;
        }
        if (this.lastCallTime == null) {
            return false;
        }
        Date expireDate = new Date(this.lastCallTime.getTime() + this.connectionExpireMs);
        return new Date().after(expireDate);
    }

    public void reduceConnectionExpireMs(long maxConnectionExpireMs) {
        if (maxConnectionExpireMs < this.connectionExpireMs) {
            this.connectionExpireMs = maxConnectionExpireMs;
        }
    }

    @Nullable
    JFedConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(@Nullable JFedConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JFedConnection getNewConnection() throws JFedException {
        return this.connectionFactory == null ? null : this.connectionFactory.create();
    }

    public boolean canDuplicate() {
        return this.connectionFactory != null;
    }

    public synchronized boolean isInUse() {
        return this.userCount > 0;
    }

    public synchronized void markInUse() {
        ++this.userCount;
        this.lastCallTime = new Date();
    }

    public synchronized void markNotInUse() {
        --this.userCount;
        this.lastCallTime = new Date();
    }

    public void registerServerCertficates(X509Certificate[] serverCertificates) {
        if (serverCertificates != null && serverCertificates.length > 0) {
            this.serverCertificates = serverCertificates;
        }
    }

    public X509Certificate[] getServerCertificates() {
        return this.serverCertificates;
    }

    public static class DebugInfo {
        @Nullable
        private final String geniUserUrn;
        @Nullable
        private final String geniUserCertificateChainPem;
        @Nullable
        private final Integer serviceId;
        @Nullable
        private final Integer serverId;
        @Nullable
        private final String serverName;
        @Nullable
        private final String serverUrn;
        @Nullable
        private final String testbedId;
        @Nullable
        private final Boolean serverHasFlagWorkaroundMustReconnectEachCall;

        public static DebugInfo createWithAllNull() {
            return new DebugInfo(null, null, null, null, null, null, null, null);
        }

        public DebugInfo(@Nullable String geniUserUrn, @Nullable String geniUserCertificateChainPem, @Nullable Integer serviceId, @Nullable Integer serverId, @Nullable String serverName, @Nullable String serverUrn, @Nullable String testbedId, @Nullable Boolean serverHasFlagWorkaroundMustReconnectEachCall) {
            this.geniUserUrn = geniUserUrn;
            this.geniUserCertificateChainPem = geniUserCertificateChainPem;
            this.serviceId = serviceId;
            this.serverId = serverId;
            this.serverName = serverName;
            this.serverUrn = serverUrn;
            this.testbedId = testbedId;
            this.serverHasFlagWorkaroundMustReconnectEachCall = serverHasFlagWorkaroundMustReconnectEachCall;
        }

        @Nullable
        public String getGeniUserUrnString() {
            return this.geniUserUrn;
        }

        @Nullable
        public String getGeniUserCertificateChainPem() {
            return this.geniUserCertificateChainPem;
        }

        @Nullable
        public Integer getServiceId() {
            return this.serviceId;
        }

        @Nullable
        public Integer getServerId() {
            return this.serverId;
        }

        @Nullable
        public String getServerName() {
            return this.serverName;
        }

        @Nullable
        public String getServerUrn() {
            return this.serverUrn;
        }

        @Nullable
        public String getTestbedId() {
            return this.testbedId;
        }

        @Nullable
        public Boolean getServerHasFlagWorkaroundMustReconnectEachCall() {
            return this.serverHasFlagWorkaroundMustReconnectEachCall;
        }

        public String toString() {
            return "DebugInfo{geniUserUrn=" + this.geniUserUrn + ", serviceId=" + this.serviceId + ", serverId=" + this.serverId + ", serverName=" + this.serverName + ", serverUrn=" + this.serverUrn + ", testbedId='" + this.testbedId + "', serverHasFlagWorkaroundMustReconnectEachCall=" + this.serverHasFlagWorkaroundMustReconnectEachCall + "}";
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlSeeAlso(value={SshProxyInfo.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static abstract class ProxyInfo {
        @XmlElement
        protected final String hostname;
        @XmlElement
        protected final int port;

        private ProxyInfo() {
            this("localhost", 8888);
        }

        @JsonCreator
        protected ProxyInfo(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") int port) {
            this.hostname = hostname;
            this.port = port;
        }

        @JsonProperty
        public String getHostname() {
            return this.hostname;
        }

        @JsonProperty
        public int getPort() {
            return this.port;
        }

        public String toString() {
            return "JFedConnection.ProxyInfo{hostname='" + this.hostname + "', port=" + this.port + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProxyInfo)) {
                return false;
            }
            ProxyInfo proxyInfo = (ProxyInfo)o;
            if (this.port != proxyInfo.port) {
                return false;
            }
            return Objects.equals(this.hostname, proxyInfo.hostname);
        }

        public int hashCode() {
            int result = this.hostname.hashCode();
            result = 31 * result + this.port;
            return result;
        }
    }

    public static interface JFedConnectionFactory {
        public JFedConnection create() throws JFedException;
    }

    @XmlRootElement(name="ssh_proxy_info")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class SshProxyInfo
    extends ProxyInfo {
        @XmlElement
        protected final String username;
        @XmlTransient
        protected final SshKeyInfo sshKeyInfo;
        @XmlElement
        protected final String hostKey;

        private SshProxyInfo() {
            this(null, -1, null, null, null);
        }

        @JsonCreator
        public SshProxyInfo(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") int port, @JsonProperty(value="username") String username, @JsonProperty(value="sshKeyInfo") SshKeyInfo sshKeyInfo, @JsonProperty(value="hostKey") String hostKey) {
            super(hostname, port);
            this.sshKeyInfo = sshKeyInfo;
            this.hostKey = hostKey;
            this.username = username;
        }

        public SshProxyInfo(SshProxyInfo o, SshKeyInfo sshKeyInfo) {
            this(o.hostname, o.port, o.username, sshKeyInfo, o.hostKey);
        }

        @JsonProperty
        public String getUsername() {
            return this.username;
        }

        @JsonIgnore
        public SshKeyInfo getSshKeyInfo() {
            return this.sshKeyInfo;
        }

        @JsonProperty
        public String getHostKey() {
            return this.hostKey;
        }

        @Override
        public String toString() {
            Object sshKeyInfoText = "HIDDEN";
            if (this.sshKeyInfo != null) {
                try {
                    sshKeyInfoText = "{ PrivKey=HIDDEN,PubKey=\"" + KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat(this.sshKeyInfo.getPublicKey()) + "\" }";
                }
                catch (UnsupportedOperationException e) {
                    sshKeyInfoText = "CANNOT SHOW: " + e.getMessage();
                }
            }
            return "JFedConnection.SshProxyInfo{hostname='" + this.hostname + "', port=" + this.port + ", username=" + this.username + ", sshKeyInfo=" + (String)sshKeyInfoText + ", hostKey=" + this.hostKey + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SshProxyInfo that = (SshProxyInfo)o;
            if (this.hostKey != null ? !Objects.equals(this.hostKey, that.hostKey) : that.hostKey != null) {
                return false;
            }
            if (!Objects.equals(this.sshKeyInfo, that.sshKeyInfo)) {
                return false;
            }
            return Objects.equals(this.username, that.username);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.username.hashCode();
            result = 31 * result + (this.sshKeyInfo != null ? this.sshKeyInfo.hashCode() : 0);
            result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
            return result;
        }
    }
}

